<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

// Get search parameters
$type = $_GET['type'] ?? '';
$term = $_GET['term'] ?? '';

if (empty($term)) {
    header('Content-Type: application/json');
    echo json_encode([]);
    exit();
}

try {
    $results = [];
    
    switch ($type) {
        case 'products':
            $stmt = $pdo->prepare("
                SELECT id, name, product_code 
                FROM products 
                WHERE name LIKE ? OR product_code LIKE ?
                ORDER BY name 
                LIMIT 5
            ");
            $searchTerm = "%{$term}%";
            $stmt->execute([$searchTerm, $searchTerm]);
            $results = $stmt->fetchAll();
            break;

        case 'customers':
            $stmt = $pdo->prepare("
                SELECT id, name, email, phone 
                FROM customers 
                WHERE name LIKE ? OR email LIKE ? OR phone LIKE ?
                ORDER BY name 
                LIMIT 5
            ");
            $searchTerm = "%{$term}%";
            $stmt->execute([$searchTerm, $searchTerm, $searchTerm]);
            $results = $stmt->fetchAll();
            break;

        case 'settings':
            // Define settings sections
            $settings = [
                ['name' => 'Store Information', 'tab' => 'store'],
                ['name' => 'Credit Settings', 'tab' => 'credit'],
                ['name' => 'Email Settings', 'tab' => 'email'],
                ['name' => 'M-Pesa Settings', 'tab' => 'mpesa'],
                ['name' => 'SMS Settings', 'tab' => 'sms'],
                ['name' => 'User Management', 'tab' => 'users'],
                ['name' => 'Roles & Permissions', 'tab' => 'roles']
            ];
            
            // Filter settings based on search term
            $results = array_filter($settings, function($setting) use ($term) {
                return stripos($setting['name'], $term) !== false;
            });
            break;

        default:
            header('Content-Type: application/json');
            echo json_encode(['error' => 'Invalid search type']);
            exit();
    }

    header('Content-Type: application/json');
    echo json_encode($results);

} catch (PDOException $e) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Database error']);
} 